/*
   This process writes a single line of 200,000 bytes
   to a pipe connected to its child process. The child
   does not read from stdin for 10 seconds, so the first
   8,000 or so bytes fill up this process's output buffer
   and the pipe buffer and then this process blocks.

   When the child calls nextLine() on its Scanner object,
   that starts to drain the pipe and the parent wakes up
   (even though the parent never calls flush()!). The
   parent can now write an almost unlimited number of
   bytes to the child as the child waits to see an end-of-line
   character (the buffer in the Scanner object just grows to
   hold all the data that comes in while it is waiting for
   an end-of-line). When the parent closes its output stream,
   that also marks end-of-line, so nextLine finally returns
   for the child.

   Notice that this process never calls flush() on its output
   buffer (except for the implicit flush() in the close()).
*/
import java.util.Scanner;
import java.io.*;

public class Ex4_WatchBuffering_Java7
{
   public static void main(String[] args) throws IOException, InterruptedException
   {
      ProcessBuilder pb = new ProcessBuilder("java", "Ex4_WatchBuffering_Child");

      // Have the child inherit the parent's standard output streams.
      pb.redirectOutput( ProcessBuilder.Redirect.INHERIT );
      pb.redirectError(  ProcessBuilder.Redirect.INHERIT );

      // Execute the child.
      Process process = pb.start();  // this throws IOException

      // A stream that writes data to the child's stdin stream (the "pipe").
      PrintStream stdinOfChild =  new PrintStream( process.getOutputStream() );

      // Write 200,000 bytes to the child's input buffer.
      for (int counter = 1; counter < 200000; counter++)
      {
         System.err.println(counter); // report of the number of bytes so far
         stdinOfChild.print("a");
      }
      stdinOfChild.close();

      process.waitFor();  // throws InterruptedException
   }
}